qui {

noi {
	/*************************************************/
	/***** Step 2.4.2. Full sample estimation	    **/
	/*************************************************/
}

	* Compute NIC-specific independence dividends and RMSPE
	noi di ""
	
		* Baseline specification
		noi di "BASELINE SPECIFICATION"
		noi di ""
		local j = 0
		cd ..
		foreach cntry of global NICs {
			
			*Report progress
			local j = `j'+1
			
			* Identify estimation window, for computation of RMSPE
			local identifier = "_10_"
			local start_RMSPE = -10
			local stop_RMSPE = -1
			
			* Check whether dividends still need to be computed
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap confirm file IDD1_all_`cntry'.dta
			if _rc == 0 {
				preserve
				cd ..
				cd ..
				cd "./4. Master data"
				use master_data, clear
				keep if cntrycode == `cntry'
				noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
				cd ..
				restore
				}
			else if _rc != 0 {
					
				* Erase potential leftover files from previous rounds
				cd ..
				cd ..
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap erase placebo1_`cntry'.dta
				cap erase Placebo1_`cntry'.dta
				forval l=1/500 {
					cap erase placebo1_`cntry'_`l'.dta
					}
				cd ..
				cd ..
				
				preserve
				cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
				use cntry_weights1_`cntry', clear
				cap sum _W_Weight
				if _rc != 0 {
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
				else if _rc == 0 {
					if `r(N)' == 0 {
						cd ..
						cd ..
						cd ..
						restore
						noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
						}
				if `r(N)' > 0 {
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
								
					* Load master data
					clear all
					cd ".\4. Master data"
					use master_data.dta, clear 
					cd ..
					
					* Generate necessary variables
					gen IDD = .
					gen rmspe = .
					gen oosrmspe = .
						
					* Label variables
					label var IDD "Raw independence dividend estimate"
					label var rmspe "Root Mean Square Prediction Error"
					label var oosrmspe "Out-of-Sample Root Mean Square Prediction Error"
								
					/* PART 1: collect the weights to construct synthetic versions of the NICs and their pool of potential control countries */

						* 1.1. Generate variable that will collect, for each NIC, the estimated (placebo) independence dividends
						 gen synth_gdpcap_`cntry' = .
						 label var synth_gdpcap_`cntry' "Counterfactual per capita GDP (in absence of state fragmentation)"
						 
						* 1.2. Collect the weights for the counterfactual country for each NIC (as assigned by the synthetic control algorithm)
						preserve
						cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
						use cntry_weights1_`cntry'.dta, clear
						gen cntrycode = _Co_Number
						gen weight_`cntry' = _W_Weight
						keep cntrycode weight_`cntry'
						save weights1_`cntry', replace
						restore
						
						* 1.3. Add them to the existing data
						merge m:1 cntrycode using weights1_`cntry'		// Collect weights for synthetic country associated with each NIC
						drop _*
						erase weights1_`cntry'.dta
						cd ..
						cd ..
						cd ..
						
						* 1.4. Construct synthetic per capita GDP trajectory for each NIC, using the weights defined by the synthetic control algorithm							
						gen weighted_gdpcap_`cntry' = weight_`cntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
						sum year if cntrycode == `cntry' & independence_years == 0 & year >= $startyear
						local yoi = r(mean)
						sum weight_`cntry' if year == `yoi' & weight_`cntry' != 0
						local componentparts = r(N)
									
						foreach year of numlist $startyear / 2016 {
							sum weighted_gdpcap_`cntry' if year == `year' & weighted_gdpcap_`cntry' != 0 
							replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `cntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' & year > $startyear // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
							}	
							
						* 1.5. Collect the weights for the counterfactual country for each potential control country of this NIC (to construct placebo gaps)
						levelsof cntrycode if weight_`cntry' != ., local(placebo_countries)	// Creates a local containing all the country codes with non-missing (but potentially zero) weights, as assigned by the synthetic control algorithm (= sample of potential control countries)
									
						local i = 1
								
						cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.1. Weights"
						foreach placebocntry of local placebo_countries {
											
								di `placebocntry', _continue
								
								* Collect the weights for the counterfactual country for each potential control country
								preserve
								cap use cntry_weights1_`cntry'_`i'.dta, clear
								if _rc == 0 {
									gen cntrycode = _Co_Number
									gen weight_`cntry'_`placebocntry' = _W_Weight
									keep cntrycode weight_`cntry'_`placebocntry'
									save weights1_`cntry'_`i', replace
									restore
												
									* Add them to the existing data
									merge m:1 cntrycode using weights1_`cntry'_`i'	// Collect weights for placebo country associated with each NIC
									drop _*
												
									* Construct synthetic per capita GDP trajectory for each placebo, using the weights defined by the synthetic control algorithm
									gen weighted_gdpcap_`cntry'_`placebocntry' = weight_`cntry'_`placebocntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
									sum weight_`cntry'_`placebocntry' if year == `yoi' & weight_`cntry'_`placebocntry' != 0
									local componentparts = r(N)
									
									foreach year of numlist $startyear / 2016 {
										sum weighted_gdpcap_`cntry'_`placebocntry' if year == `year' & weighted_gdpcap_`cntry'_`placebocntry' != 0 
										replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `placebocntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were determined by the SCM
										}	
													
									* Erase obsolete data
									erase weights1_`cntry'_`i'.dta
									}
								else if _rc != 0 {
									restore
									}
								local i = `i' + 1
								}
						cd ..
						cd ..
						cd ..
						
					/* PART 2: estimate independence dividends + RMSPE */

						* 2.1. Independence dividend
						gen synth_lgdpcap_`cntry' = ln(synth_gdpcap_`cntry')
						gen gap_`cntry' = baseline_gdpcap - synth_gdpcap_`cntry'
						gen lgap_`cntry' = baseline_lgdpcap - synth_lgdpcap_`cntry'
						replace IDD = lgap_`cntry' if cntrycode == `cntry'
						
						* 2.2. Root Mean Squared Prediction Error (RMSPE)
						levelsof cntrycode if lgap_`cntry' != ., local(placebo_countries)
						foreach placebocntry of local placebo_countries {
							scalar SPE_`placebocntry' = 0
							scalar total_observations_`placebocntry' = 0
							foreach year of numlist `start_RMSPE'/`stop_RMSPE' {
								sum year if cntrycode == `cntry' & independence_years == `year' & year > $startyear
								if `r(N)' != 0 {
									sum lgap_`cntry' if cntrycode == `placebocntry' & year == `r(mean)'
									if r(mean) != . {
										scalar SPE_`placebocntry' = SPE_`placebocntry' + (r(mean)^2)
										scalar total_observations_`placebocntry' = total_observations_`placebocntry' + 1
										}
									}
								}
							scalar MSPE_`placebocntry' = SPE_`placebocntry'/total_observations_`placebocntry'
							scalar RMSPE_`placebocntry' = sqrt(MSPE_`placebocntry')
							replace rmspe = RMSPE_`placebocntry' if cntrycode == `placebocntry'
							}
													
						* Drop unnecessaries
						drop weight*
						
						* Save estimates for this NIC
						
							* NIC-specific results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year baseline_lgdpcap synth_lgdpcap
							drop if cntrycode != `cntry'
							drop if IDD == .
							sum independence_years if cntrycode == `cntry' & year >= $startyear
							sum year if cntrycode == `cntry' & independence_years == `r(min)' & year >= $startyear
							drop if year < `r(mean)'
							sort cntrycode independence_years
							cd ".\3. Intermediary results\3.4. Intermediaries"
							save IDD1_all_`cntry', replace
							sum independence_years if cntrycode == `cntry'
							local min = max(-15,`r(min)')
							sum year if cntrycode == `cntry' & independence_years == `min'
							drop if year < `r(mean)'
							save IDD1_`cntry', replace
							cd ..
							cd ..
							restore
							
							* Including placebo results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year lgap_`cntry'
							drop if independence_years == .
							drop if lgap_`cntry' == .
							sum independence_years if cntrycode == `cntry'
							local min = max(-15,`r(min)')
							sum year if cntrycode == `cntry' & independence_years == `min'
							drop if year < `r(mean)'
							sort cntrycode independence_years
							cd ".\3. Intermediary results\3.4. Intermediaries"
							save PIDD1_`cntry', replace
							cd ..
							cd ..
							restore
						}
					}
				}
			}
		
	
		* Robustness check
		// Move independence declaration forward by 5 years, to account for potential anticipation effects
		noi di ""
		noi di "ALTERNATIVE SPECIFICATION:"
		noi di ""

		local j = 0
		foreach cntry of global NICs {
			
			*Report progress
			local j = `j'+1
			
			* Identify estimation window, for computation of RMSPE
			local identifier = "_10_"
			local start_RMSPE = -15
			local stop_RMSPE = -6
			
			* Check whether dividends still need to be computed
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap confirm file IDD2_`cntry'.dta
			if _rc == 0 {
				preserve
				cd ..
				cd ..
				cd "./4. Master data"
				use master_data, clear
				keep if cntrycode == `cntry'
				noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
				cd ..
				restore
				}
			else if _rc != 0 {
					
				* Erase potential leftover files from previous rounds
				cd ..
				cd ..
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap erase placebo1_`cntry'.dta
				cap erase Placebo1_`cntry'.dta
				forval l=1/500 {
					cap erase placebo1_`cntry'_`l'.dta
					}
				cd ..
				cd ..
				
				preserve
				cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
				clear all
				cap use cntry_weights2_`cntry', clear
				cap sum _W_Weight
				if _rc != 0 {
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
				else if _rc == 0 {
					if `r(N)' == 0 {
						cd ..
						cd ..
						cd ..
						restore
						noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
						}
				if `r(N)' > 0 {
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
								
					* Load master data
					clear all
					cd ".\4. Master data"
					use master_data.dta, clear 
					cd ..
					
					* Generate necessary variables
					gen IDD = .
					gen rmspe = .
					gen oosrmspe = .
						
					* Label variables
					label var IDD "Raw independence dividend estimate"
					label var rmspe "Root Mean Square Prediction Error"
					label var oosrmspe "Out-of-Sample Root Mean Square Prediction Error"
								
					/* PART 1: collect the weights to construct synthetic versions of the NICs and their pool of potential control countries */

						* 1.1. Generate variable that will collect, for each NIC, the estimated (placebo) independence_dividends
						 gen synth_gdpcap_`cntry' = .
						 label var synth_gdpcap_`cntry' "Counterfactual per capita GDP (in absence of state fragmentation)"
						 
						* 1.2. Collect the weights for the counterfactual country for each NIC (as assigned by the synthetic control algorithm)
						preserve
						cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
						use cntry_weights2_`cntry'.dta, clear
						gen cntrycode = _Co_Number
						gen weight_`cntry' = _W_Weight
						keep cntrycode weight_`cntry'
						save weights2_`cntry', replace
						restore
						
						* 1.3. Add it to the existing data
						merge m:1 cntrycode using weights2_`cntry'		// Collect weights for synthetic country associated with each NIC
						drop _*
						erase weights2_`cntry'.dta
						cd ..
						cd ..
						cd ..
						
						* 1.4. Construct synthetic per capita GDP trajectory for each NIC, using the weights defined by the synthetic control algorithm							
						gen weighted_gdpcap_`cntry' = weight_`cntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
						sum year if cntrycode == `cntry' & independence_years == 0 & year >= $startyear
						local yoi = r(mean)
						sum weight_`cntry' if year == `yoi' & weight_`cntry' != 0
						local componentparts = r(N)
									
						foreach year of numlist $startyear / 2016 {
							sum weighted_gdpcap_`cntry' if year == `year' & weighted_gdpcap_`cntry' != 0 
							replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `cntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' & year > $startyear // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
							}	
							
						* 1.5. Collect the weights for the counterfactual country for each potential control country of this NIC (to construct placebo gaps)
						levelsof cntrycode if weight_`cntry' != ., local(placebo_countries)	// Creates a local containing all the country codes with non-missing (but potentially zero) weights, as assigned by the synthetic control algorithm (= potential control countries)
									
						local i = 1
								
						cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.1. Weights"
						foreach placebocntry of local placebo_countries {
											
								di `placebocntry', _continue
								
								* Collect the weights for the counterfactual country for each potential control country
								preserve
								cap use cntry_weights2_`cntry'_`i'.dta, clear
								if _rc == 0 {
									gen cntrycode = _Co_Number
									gen weight_`cntry'_`placebocntry' = _W_Weight
									keep cntrycode weight_`cntry'_`placebocntry'
									save weights2_`cntry'_`i', replace
									restore
												
									* Add it to the existing data
									merge m:1 cntrycode using weights2_`cntry'_`i'	// Collect weights for placebo country associated with each NIC
									drop _*
												
									* Construct synthetic per capita GDP trajectory for each placebo, using the weights defined by the synthetic control algorithm
									gen weighted_gdpcap_`cntry'_`placebocntry' = weight_`cntry'_`placebocntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
									sum weight_`cntry'_`placebocntry' if year == `yoi' & weight_`cntry'_`placebocntry' != 0
									local componentparts = r(N)
									
									foreach year of numlist $startyear / 2016 {
										sum weighted_gdpcap_`cntry'_`placebocntry' if year == `year' & weighted_gdpcap_`cntry'_`placebocntry' != 0 
										replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `placebocntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were determined by the SCM
										}	
													
									* Erase obsolete data
									erase weights2_`cntry'_`i'.dta
									}
								else if _rc != 0 {
									restore
									}
								local i = `i' + 1
								}
						cd ..
						cd ..
						cd ..
						
					/* PART 2: estimate independence dividends + RMSPE */

						* 2.1. Independence dividend
						gen synth_lgdpcap_`cntry' = ln(synth_gdpcap_`cntry')
						gen gap_`cntry' = baseline_gdpcap - synth_gdpcap_`cntry'
						gen lgap_`cntry' = baseline_lgdpcap - synth_lgdpcap_`cntry'
						replace IDD = lgap_`cntry' if cntrycode == `cntry'
						
						* 2.2. Root Mean Squared Prediction Error (RMSPE)
						scalar SPE_`cntry' = 0
						scalar total_observations_`cntry' = 0
						foreach year of numlist `start_RMSPE'/`stop_RMSPE' {
							sum lgap_`cntry' if cntrycode == `cntry' & independence_years == `year' & year > $startyear
							if r(mean) != . {
								scalar SPE_`cntry' = SPE_`cntry' + (r(mean)^2)
								scalar total_observations_`cntry' = total_observations_`cntry' + 1
								}
							}
						scalar MSPE_`cntry' = SPE_`cntry'/total_observations_`cntry'
						scalar RMSPE_`cntry' = sqrt(MSPE_`cntry')
						replace rmspe = RMSPE_`cntry' if cntrycode == `cntry'
													
						* Drop unnecesaries
						drop weight*
						
						* Save estimates for this NIC
						
							* NIC-specific results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year baseline_lgdpcap synth_lgdpcap
							drop if cntrycode != `cntry'
							drop if IDD == .
							sum independence_years if cntrycode == `cntry'
							local min = max(-15,`r(min)')
							sum year if cntrycode == `cntry' & independence_years == `min'
							drop if year < `r(mean)'
							sort cntrycode independence_years
							cd ".\3. Intermediary results\3.4. Intermediaries"
							save IDD2_`cntry', replace
							cd ..
							cd ..
							restore
							
							* Including placebo results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year lgap_`cntry'
							drop if independence_years == .
							drop if lgap_`cntry' == .
							sum independence_years if cntrycode == `cntry'
							local min = max(-15,`r(min)')
							sum year if cntrycode == `cntry' & independence_years == `min'
							drop if year < `r(mean)'
							sort cntrycode independence_years
							cd ".\3. Intermediary results\3.4. Intermediaries"
							save PIDD2_`cntry', replace
							cd ..
							cd ..
							restore
						}
					}
				}
			}
	
	
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
